//___________________________________
//                                   \
// Phenibut Pushing algorithm extending Lithonite.  version 1.4	$Id: phenibut.js 97 2008-07-13 12:21:56Z nilton $
//___________________________________/

/*
 Extents lithonite functions with new ones. Now we can push other sprites.
 Works with Lithonite 1.9

 First, before including this library, be sure to:

 	RequireScript("lib/lithonite.js");


   Known Bugs: Uh... let's call them 'features', shall we?
   The effort has been focused on _not_ getting obstructed while in vincity of
   moving objects. Movement is choppy as of now.

*******************************************************************************
*/

/**
 * Extend LithoniteEngine with a variable to mark push retriggers
 * Sphere has this bug that when you are pushing something, and you 
 * then push something else, it will not trigger the "on touch" of that
 * second person.
 */
LithoniteEngine.prototype.repush=0;

/**
 * Internal function will be redefined to restore the GIP's directions.
 * (GIP stands for Get Input Person)
 */
LithoniteEngine.prototype.restore=function(){};

/**
 * Redefine CalcVectors to include Restore
 * Calculates the movement vectors, based on the cursor keys you are pressing. 
 * You need to call this each frame inside the Update script
 * @returns 0 if there is no cursor movent (pressing up and down at the same time results in no movement), 1 if there is. 
 * After calcVectors, you need to call {@link LithoniteEngine#deObstruct} 
 * @type integer
 */
LithoniteEngine.prototype.calcVectors = function() {
        if(this.moving==2)return 0;
        this.move_x=this.move_y=0;
        if(IsKeyPressed(KEY_UP)   ) {this.moving=1; --this.move_y;}
        if(IsKeyPressed(KEY_RIGHT)) {this.moving=1; ++this.move_x;}
        if(IsKeyPressed(KEY_DOWN) ) {this.moving=1; ++this.move_y;}
        if(IsKeyPressed(KEY_LEFT) ) {this.moving=1; --this.move_x;}
        if(!this.moving){++this.idle;if(this.pushing){this.pushing=0;this.restore();};return 0;}
        this.idle=0;
        if(this.move_x||this.move_y){this.hist_x=this.move_x;this.hist_y=this.move_y;return 1;}
        return 0;
}

//----------------------------------------------------------------------------//

/**
 * Unfinished function. Will make an object 'pullable'.
 * It will use the directions grab_north, grab_west, etc if available.
 * @param {float} heavyness The speed you will slow down to while pushing this thing
 * @param {Boolean} gridon Will only allow movement from tile to tile. It fixes your movement to 16 pixels each time
 * @param {Boolean} animated Will animate the object while you push it, else it will be static
 * @param {Boolean} ConfinedToZone You can push the thing around inside a zone (the zone script can be empty). The whole PersonBase stays inside a zone.
 * @param {integer} pulldelay How long do you have to pull something for it to start moving
 * @returns false if object cant be pulled (for example: its outside a zone)
 */
LithoniteEngine.prototype.Pullable = function(heavyness,gridon,animated,ConfinedToZone,pulldelay) {
	this.pulling++;
	var GCP=GetCurrentPerson();
	var offset=gridon?16:1; //16 === this.move_x?this.GTW():this.GTH()
	if(ConfinedToZone) {
		var base=GetPersonBase(GCP);
		var xmin=(base.x2-base.x1)>>1;
		var ymin=(base.y1-base.y2)>>1;
		var GPL=GetPersonLayer(GCP);

		if(	!AreZonesAt(GPXX-xmin,GPYY-ymin,GPL) ||
			!AreZonesAt(GPXX+xmin+1,GPYY+ymin+1,GPL) ||
			!AreZonesAt(GPXX+xmin+1,GPYY-ymin,GPL) ||
			!AreZonesAt(GPXX-xmin,GPYY+ymin+1,GPL)
		) {
			this.restore();
			return false;
		}
	}
 
	FollowPerson(GCP, this.GIP, 16);
	SetPersonSpeedXY(this.GIP,heavyness,heavyness);
	this.SwapDirections("grab_");
	this.restore=new Function(""
		+"FollowPerson('"+GPC+"','',0);"
		+"this.SwapDirections('grab_');"
		+"this.rectifySpeed();this.moving=1;this.active=this.wasactive;"
		+"this.restore=function(){};this.standStill();this.AttachGIP();"
		+"TryExecuteTriggersNZones(GetPersonX('"+GCP+"'),GetPersonY('"+GCP+"'),GetPersonLayer('"+GCP+"'));"
	); 
	return true;
}

/**
 * Put this function in a person's script SCRIPT_ON_ACTIVATE_TOUCH to be able to push it.
 * @param {float} heavyness The speed you will slow down to while pushing this thing
 * @param {Boolean} slippery Disable lithonite so you dont slip around the thing you are pushing. Drawback: when pushing into a hall, there is no lithonite to help you walk.
 * @param {Boolean} gridon Will only allow movement from tile to tile. It fixes your movement to 16 pixels each time
 * @param {Boolean} animated Will animate the object while you push it, else it will be static
 * @param {Boolean} propagate True if the thing you are pushing can push another thing
 * @param {Boolean} ConfinedToZone You can push the thing around inside a zone (the zone script can be empty). The whole PersonBase stays inside a zone.
 * @param {integer} pushdelay How long do you have to push something for it to start moving
 * @param {Boolean} keepsrolling Once you pushed it, will it keep on rolling until it hits an obstruction?
 * @returns true if you could push it
 */
LithoniteEngine.prototype.Pushable = function(heavyness,slippery,gridon,animated,propagate,ConfinedToZone,pushdelay,keepsrolling) {
	this.pushing++;

	var GCP=GetCurrentPerson();
	var offset=gridon?16:1; //16 === this.move_x?this.GTW():this.GTH()
	var GPXX=GetPersonX(GCP)+this.hist_x*offset;
	var GPYY=GetPersonY(GCP)+this.hist_y*offset;
	if(ConfinedToZone) {
		var base=GetPersonBase(GCP);
		var xmin=(base.x2-base.x1)>>1;
		var ymin=(base.y1-base.y2)>>1;
		var GPL=GetPersonLayer(GCP);

		if(	!AreZonesAt(GPXX-xmin,GPYY-ymin,GPL) ||
			!AreZonesAt(GPXX+xmin+1,GPYY+ymin+1,GPL) ||
			!AreZonesAt(GPXX+xmin+1,GPYY-ymin,GPL) ||
			!AreZonesAt(GPXX-xmin,GPYY+ymin+1,GPL)
		) {
			this.restore();
			return false;
		}
	}

	if((typeof pushdelay=="number") && pushdelay>this.pushing && IsInputAttached()) {
		if(this.repos(-this.hist_x,-this.hist_y)) return 0; //Sprite can 'touch' again
		//Sprite is standing next to us and we cant create a space between us to touch again.
		this.repush=pushdelay;
		return 0;
	}

	if(keepsrolling){
		dir=this.getCommand(1,this.hist_x,this.hist_y);
		SetPersonScript(GCP,SCRIPT_COMMAND_GENERATOR,
			"GPXX=GetPersonX('"+GCP+"')+"+this.hist_x+";"+
			"GPYY=GetPersonY('"+GCP+"')+"+this.hist_y+";"+
			"if(IsPersonObstructed('"+GCP+"',GPXX,GPYY))SetPersonScript('"+GCP+"',SCRIPT_COMMAND_GENERATOR,'');"+
			"else QueuePersonCommand('"+GCP+"',"+this.getCommand(1,this.hist_x,this.hist_y)+",true);"
		);
	}

	if(!IsPersonObstructed(GCP,GPXX,GPYY)) {
		if((gridon||animated)&&(this.hist_x&&this.hist_y)) {
			return;
		}
		SetPersonSpeedXY(this.GIP,heavyness,heavyness);
		this.wasactive = this.active;
		if(!slippery)
			this.active=0;

		if(gridon||animated) {
			if(IsCommandQueueEmpty(GCP)) {
				if(animated) 
					QueuePersonCommand(GCP, this.getCommand(0,this.hist_x,this.hist_y), true);
				var godir=this.getCommand(1,this.hist_x,this.hist_y);
				//round float. Obscene Sphere bug.(javascript, actually...)
				this.repos(0,0,GCP);

				if(gridon) {
					//Valid Speed: .128;.2;.25,.3;.39;.45;.5;.55;.6;.628;.65;.7;.75;.79;.85;.872;.9;.95;.99
					//Fix invalid heavynesses: .1, .8;.4;1
					if(heavyness==1||heavyness==.1||heavyness==.4||heavyness==.8)
						heavyness-=.01;
					SetPersonSpeedXY(GCP,heavyness,heavyness);
					SetPersonSpeedXY(this.GIP,heavyness,heavyness);

					ClearPersonCommands(this.GIP);
					QueuePersonCommand(this.GIP, this.getCommand(0,this.move_x,this.move_y) ,true);

					this.moving=2;
					var WasInputAttached = IsInputAttached();
					//this.restore=function(){};
					if(WasInputAttached) {
						if(WasInputAttached)
							this.SwapDirections("push_",this.GIP);
						this.restore=new Function(""
							+"this.setGIPBehind();"
							//+"FollowPerson(this.GIP,'',0);"
							+"this.SwapDirections('push_');"
							+"this.rectifySpeed();this.moving=1;this.active=this.wasactive;"
							+"this.restore=function(){};this.standStill();this.AttachGIP();"
							+"TryExecuteTriggersNZones(GetPersonX('"+GCP+"'),GetPersonY('"+GCP+"'),GetPersonLayer('"+GCP+"'));"
						); 
						this.DetachGIP();
						var xx=GetPersonXFloat(this.GIP);
						var yy=GetPersonYFloat(this.GIP);
						//FollowPerson(this.GIP, GCP, this.move_x?this.GTW()<<1:this.GTH()<<1 ); //32 === 2 * this.move_x?this.GTW():this.GTH();
						//SetPersonXYFloat(this.GIP, xx,yy);
					}
					var Moves=Math.floor(16/heavyness);
					var moves=Moves-1;
					if((this.hist_x>0)||(this.hist_y>0))
						moves+=1; //FIX Sphere BUG
					if((this.hist_x<0)||(this.hist_y<0))
						moves-=1; //FIX Sphere BUG

					QueuePersonCommand(GCP, godir, true);
					//if((this.hist_x>0)||(this.hist_y>0))QueuePersonCommand(this.GIP, COMMAND_WAIT, false);
					//if((this.hist_x<0)||(this.hist_y<0))QueuePersonCommand(this.GIP, COMMAND_WAIT, false);
					QueuePersonCommand(this.GIP, COMMAND_WAIT, false);
					do{
						QueuePersonCommand(GCP, godir, false);
						QueuePersonCommand(this.GIP, godir, false);
					}while(--moves);

					//if((this.hist_x<0)||(this.hist_y<0))QueuePersonCommand(this.GIP, godir, false);

					//var cx=GetPersonX(GCP)%GetTileWidth();
					//var cy=GetPersonY(GCP)%GetTileHeight();
					QueuePersonScript(GCP, this.objname+".recenter('"+GCP+"')" ,false);
					QueuePersonScript(GCP, this.objname+".StopPushing('"+GCP+"')",false);
				} else {
					var i=offset;do{QueuePersonCommand(GCP, godir, false);}while(--i);
					QueuePersonScript(GCP, this.objname+".rectifySpeed();"+this.objname+".active=1",false);
					//QueuePersonScript(GCP, this.objname+".reposNextTo('"+GPC+"',16,0,'"+Lithonite.GIP+"')" ,false);
					//QueuePersonScript(GCP, this.objname+".repos(0,0)" ,false);
				}
			}
			//else Abort('kaaa')
		} else {
			//SetPersonX(GCP,GPXX); SetPersonY(GCP,GPYY); QueuePersonCommand(GCP, COMMAND_ANIMATE, false);
			QueuePersonCommand(GCP, this.getCommand(1,this.hist_x,this.hist_y), false);
			QueuePersonScript(GCP, this.objname+".rectifySpeed();"+this.objname+".active=1",false);
			//QueuePersonScript(GCP, this.objname+".reposNextTo('"+GPC+"',16,0,'"+Lithonite.GIP+"')" ,false);
			//	QueuePersonScript(GCP, this.objname+".repos(0,0)" ,false);
			//this.repos(-this.hist_x*0.5,-this.hist_y*0.5);
		}
	  } else {
		if(propagate) {
			var NPC=GetObstructingPerson(GCP,GPXX,GPYY);
			if(NPC != ""){ //#Obstruction is person, not a tile
				CallPersonScript(NPC, SCRIPT_ON_ACTIVATE_TOUCH);
				//SetPersonX(this.GIP,GetPersonX(this.GIP)-this.hist_x);
				//SetPersonY(this.GIP,GetPersonY(this.GIP)-this.hist_y);
				//if((this.hist_x<0)||(this.hist_y<0))
				this.repos(-this.hist_x,-this.hist_y);
				//else
				//this.repos(-this.hist_x*2,-this.hist_y*2);
				this.touching="";this.touched="X"; //TODO:why X?
			}
		}
		else {
			return false;
		}
  	}
	return true;
}


//----------------------------------------------------------------------------//

/**
 * Internal function. Stop pushing a thing. Called by {@link LithoniteEngine#Pushable}
 * @param {string} GCP Name of the thing we want to stop pushing
 */
LithoniteEngine.prototype.StopPushing = function(GCP){
	var old_xy= this.hist_x+(this.hist_y<<2);
	this.moving=1;
	this.pushing=1;
	this.calcVectors();
	this.restore();
	if(old_xy != this.move_x+(this.move_y<<2))
		this.pushing=0;
	if (!this.pushing) return false;
	if(IsCommandQueueEmpty(this.GIP)){
		this.setGIPBehind();
		if((this.hist_x<0)||(this.hist_y<0)){ //Float bugs in spidermonkey
			QueuePersonScript(this.GIP, "CallPersonScript('"+GCP+"', SCRIPT_ON_ACTIVATE_TOUCH);" ,false);
		}else{
			CallPersonScript(GCP, SCRIPT_ON_ACTIVATE_TOUCH);
		}
	} else{
		QueuePersonScript(this.GIP, this.objname+".StopPushing('"+GCP+"')",false);
	}
}


/**
 * Center a person on a tile, if not obstructed there
 * Lithonite.recenter(); Centers the .GIP on its current tile
 * Lithonite.recenter(person, 0, 1); Centers person on its current tile on the Y-axis only
 * @param {string} person Name of the sprite you want to recenter on a tile. Defaults to this.GIP
 * @param {Boolean} do_x recenter on this axis, leave undefined to be set automatically, if needed.
 * @param {Boolean} do_y recenter on this axis, leave undefined to be set automatically, if needed.
 * @returns true if it was repositioned, false if it didn't.
 */
LithoniteEngine.prototype.recenter = function(person,do_x,do_y) {
	person=person||this.GIP;
	var $GPXX = GetPersonXFloat(person);
	var $GPYY = GetPersonYFloat(person);
	if(do_x == undefined)
		do_x=this.hist_x;
	if(do_y == undefined)
		do_y=this.hist_y;

	if(do_x)
		$GPXX=(($GPXX>>4)<<4)-1+(GetTileWidth()>>1);
	if(do_y)
		$GPYY=(($GPYY>>4)<<4)-1+(GetTileHeight()>>1);

	if(!IsPersonObstructed(person,$GPXX,$GPYY)) {
		SetPersonXYFloat(person,$GPXX,$GPYY);
		return true;
	}
	return false;
}

/**
 * Sets the GIP behind a person 
 * @param {string} person Name of the sprite you want to put yourself behind. Defaults to GetCurrentPerson()
 * @param {Boolean} do_x recenter on this axis, leave undefined to be set automatically, if needed.
 * @param {Boolean} do_y recenter on this axis, leave undefined to be set automatically, if needed.
 * @returns true if it was repositioned, false if it didn't.
 */
LithoniteEngine.prototype.setGIPBehind = function(person,m_x,m_y) {
	if(m_x==undefined)
		m_x = this.hist_x;
	if(m_y==undefined)
		m_y = this.hist_y;
	var base1 = GetPersonBase(person||GetCurrentPerson());
	var base2 = GetPersonBase(this.GIP);
	var d=0;

	if(m_x){
		d += ((base1.x2-base1.x1)>>1);
		d += ((base2.x2-base2.x1)>>1);
		m_x *= d;
	} else if(m_y){
		d += ((base1.y2-base1.y1)>>1);
		d += ((base2.y2-base2.y1)>>1);
		m_y *= d;
	}
	this.repos(m_x,m_y);
}

//----------------------------------------------------------------------------//

/**
 * Get tile width, will not die if the mapengine is not running.
 * @returns the current tile width
 */
LithoniteEngine.prototype.GTW=function(){return IsMapEngineRunning()? GetTileWidth():16;} //TileWidth, used in phenibut
/**
 * Get tile height
 * @returns the current tile height
 */
LithoniteEngine.prototype.GTH=function(){return IsMapEngineRunning()? GetTileHeight():16;} //TileHeight, used in phenibut

/**
 * Get the tile index number the person is standing on
 * @param {string} person Name of the sprite
 * @param {Boolean} SkipIfOffscreen If you are outside the map, the function will Abort Sphere, so keep it false/undefined
 * returns a tile index, or -1 if offscreen.
 */
LithoniteEngine.prototype.GetCurrentTile = function(person,SkipIfOffscreen){
	person=person||this.GIP; 
	var TX=this.MapToTileX(GetPersonX(person));
	var TY=this.MapToTileY(GetPersonY(person));
	if(SkipIfOffscreen&&((TX<0)||(TY<0)||(TX>=GetLayerWidth(GetPersonLayer(person)))||(TY>=GetLayerHeight(GetPersonLayer(person)))))
		return -1;
	return GetTile(TX,TY,GetPersonLayer(person));
}


/**
 * This tries to guess what the facing tile is. It errs when two cursorkeys are pressed, as it looks diagonally.
 * @param {string} person Name of the sprite
 * @param {Boolean} SkipIfOffscreen If you are outside the map, the function will Abort Sphere, so keep it false/undefined
 * returns a tile index, or -1 if outside the screen or map
 */
LithoniteEngine.prototype.GetFacingTile = function(person,SkipIfOffscreen){ 
	person=person||this.GIP;
	if(person==this.GIP){
		var GPX=GetPersonX(person)+this.hist_x*this.GTW();
		var GPY=GetPersonY(person)+this.hist_y*this.GTH();
		if(SkipIfOffscreen&&((GPX<0)||(GPY<0)||(GPX>GetLayerWidth(GetPersonLayer(person)))||(GPY>GetLayerHeight(GetPersonLayer(person)))))
			return -1;
		return GetTile(this.MapToTileX(GPX),this.MapToTileY(GPY),GetPersonLayer(person));
	}
	var x=0;var y=0;
	switch(GetPersonDirection(person)){
		case 'northwest': x=-1;y=-1;break;
		case 'north': y=-1;break;
		case 'northeast': x=1;y=-1;break;
		case 'west': x=-1;break;
		case 'east': x=1;break;
		case 'southwest': x=1;y=1;break;
		case 'south': y=1;break;
		case 'southeast': x=1;y=1;break;
	}
	var GPX=GetPersonX(person)+x*this.GTW();
	var GPY=GetPersonY(person)+y*this.GTH();
	if(SkipIfOffscreen&&((GPX<0)||(GPY<0)||(GPX>GetLayerWidth(GetPersonLayer(person)))||(GPY>GetLayerHeight(GetPersonLayer(person)))))
		return -1;
	return GetTile(this.MapToTileX(GPX),this.MapToTileY(GPY),GetPersonLayer(person));
}

/**
 * Encodes a direction to a number, the opposite of {@link LithoniteEngine#getMoveDir}
 * @param {string} dir A cardinal direction, like 'north', 'northeast', etc.
 * @param {boolean} vector Return an object with .x and .y values instead of a number. Defaults to false.
 * @returns a number you can feed {@link LithoniteEngine#Move2Vector} to get directional vectors 
 */
LithoniteEngine.prototype.getDirMove= function(dir, vector){ 
	var x=0;var y=0;
	if(dir.match(/north/)) y = -1;
	if(dir.match(/south/)) y = 1;
	if(dir.match(/west/)) x = -1;
	if(dir.match(/east/)) x = 1;
	if(vector)return{x:x, y:y};
	return x+(y<<2);
};

/**
 * @param {number} d Numerical direction created with x+(y<<2)
 * these x and y can be -1, 0 or 1.
 * @returns an object with .x and .y properties (unitarian vectors)
 */
LithoniteEngine.prototype.Move2Vector=function(d){
	var y=(1+d>>2)&-1;
	return {x:d-(y<<2),y:y};
}

/**
 * Like SetDir (Lithonite), and also set the historical lithonite vectors.
 * @param {string} direction A direction in the spriteset, like 'north', 'northeast', etc.
 */
LithoniteEngine.prototype.SetDirGIP = function(direction){
	if(this.setDir(direction, this.GIP)){
		var v = this.getDirMove(direction, true);
		this.hist_x = v.x;
		this.hist_y = v.y;
	}
}

//----------------------------------------------------------------------------//

/**
 * Map X coordinate to tile X coordinate
 * It will redefine itself with a faster function if the tilewidth is 16
 * @param {number} x A position on the map
 * @returns a number in tiles
 */
LithoniteEngine.prototype.MapToTileX = function(x){
	if(this.GTW()==16)
		LithoniteEngine.prototype.MapToTileX = new Function("x", "{return x>>4;}");
	else
		LithoniteEngine.prototype.MapToTileX = new Function("x", "{return Math.floor(x/this.GTW());}");
	return Math.floor(x/this.GTW());
}

//----------------------------------------------------------------------------//

/**
 * Map Y coordinate to tile Y coordinate
 * It will redefine itself with a faster function if the tilewidth is 16
 * @param {number} y A position on the map
 * @returns a number in tiles
 */
LithoniteEngine.prototype.MapToTileY = function(y){
	if(this.GTH()==16)
		LithoniteEngine.prototype.MapToTileY = new Function("y", "{return y>>4;}");
	else
		LithoniteEngine.prototype.MapToTileY = new Function("y", "{return Math.floor(y/this.GTH());}");
	return Math.floor(y/this.GTH());
}

//----------------------------------------------------------------------------//

/**
 * Tile X coordinate to map X coordinate
 * It will redefine itself with a faster function if the tilewidth is 16
 * @param {number} x A tile position on the map
 * @returns a number in map coordinates
 */
LithoniteEngine.prototype.TileToMapX = function(xx) { 
	if(this.GTW()==16)
		LithoniteEngine.prototype.TileToMapX = new Function("xx", "{return (xx<<4)+7;}");
	else
		LithoniteEngine.prototype.TileToMapX = new Function("xx", "{return Math.floor(xx*this.GTW()+(this.GTW()>>1)-1);}");
	return Math.floor(xx*this.GTW()+(this.GTW()>>1)-1);
}

//----------------------------------------------------------------------------//

/**
 * Tile Y coordinate to map Y coordinate
 * It will redefine itself with a faster function if the tilewidth is 16
 * @param {number} y A tile position on the map
 * @returns a number in map coordinates
 */
LithoniteEngine.prototype.TileToMapY = function(yy) { 
	if(this.GTH()==16)
		LithoniteEngine.prototype.TileToMapY = new Function("yy", "{return (yy<<4)+7;}");
	else
		LithoniteEngine.prototype.TileToMapY = new Function("yy", "{return Math.floor(yy*this.GTH()+(this.GTH()>>1)-1);}");
	return Math.floor(yy*this.GTH()+(this.GTH()>>1)-1);
}

/**
 * Get the X coordinate in tiles
 * @param {string} person Name of the sprite you want this information for
 * @returns a number in tile map coordinates
 */
LithoniteEngine.prototype.GetPersonTX = function(person){
	return this.MapToTileX(GetPersonX(person||this.GIP));
}

/**
 * Get the Y coordinate in tiles
 * @param {string} person Name of the sprite you want this information for
 * @returns a number in tile map coordinates
 */
LithoniteEngine.prototype.GetPersonTY = function(person){
	return this.MapToTileY(GetPersonY(person||this.GIP));
}

//----------------------------------------------------------------------------//

/**
 * Is person obstructed at current position + (dx,dy) offset
 * @param {number} dx Offset in X-Axis
 * @param {number} dy Offset in Y-Axis
 * @param {string} person Name of the sprite you want this information for
 * @returns true if the person is obstructed there, false if not.
 * @type boolean
 */
LithoniteEngine.prototype.isObstructedAtDelta = function(dx,dy,person){
	person=person||this.GIP; 
	return IsPersonObstructed(person,GetPersonX(person)+dx, GetPersonY(person)+dy);
}

//----------------------------------------------------------------------------//

/**
 * Will execute any zones and triggers defined in map coordinates
 * @param {number} map_x X-axis Map coordinate in pixels
 * @param {number} map_y Y-axis Map coordinate in pixels
 * @param {integer} layer Layer on which to check for triggers and zones. Currently broken, it will check all layers. This parameter is optional for now.
 * @returns true if a trigger or zone is found, false if nothing was found at the given coordinates.
 * @type boolean
 */
function TryExecuteTriggersNZones(map_x, map_y, layer) {
	var found=false;
	if(AreZonesAt(map_x, map_y, layer||0)){
		ExecuteZones(map_x, map_y, layer||0);
		found=true;
	}
	if(IsTriggerAt(map_x, map_y, layer||0)){
		ExecuteTrigger(map_x, map_y, layer||0);
		found=true;
	}
	return found;
}

//----------------------------------------------------------------------------//

/**
 * Will execute any trigger defined in tile coordinates
 * @param {integer} tile_x X-axis Map coordinate in tiles
 * @param {integer} tile_y Y-axis Map coordinate in tiles
 * @param {integer} layer Layer on which to check for triggers and zones. Currently broken, it will check all layers. This parameter is optional for now.
 * @returns true if there was a trigger to execute, false if not.
 * @type boolean
 */
function ExecuteTriggerTileXY(tile_x, tile_y, layer) {
	var map_x=LithoniteEngine.prototype.TileToMapX(tile_x);
	var map_y=LithoniteEngine.prototype.TileToMapY(tile_y);
	if(IsTriggerAt(map_x, map_y, layer||0)){
		ExecuteTrigger(map_x, map_y, layer||0);
		return true;
	}else
		return false;
}

//----------------------------------------------------------------------------//

/**
 * all except your input person will quietly walk over any triggers. If you need a NPC to trigger, you need to call this function.
 * @param {string} NPC the Non Playable Character you want to test for triggers, and run the triggers.
 * @returns true if a trigger was found (and executed) where the NPC was standing on.
 * @type boolean
 */
function Entrigger(NPC) {
	if(IsTriggerAt(GetPersonX(NPC), GetPersonY(NPC),  GetPersonLayer(NPC))){
		ExecuteTrigger(GetPersonX(NPC), GetPersonY(NPC),  GetPersonLayer(NPC));
		return true;
	};
	return false;
}

/**
 * all except your input person will quietly walk over any triggers and zones. If you need a NPC to trigger, you need to call this function.
 * @param {string} NPC the Non Playable Character you want to test for triggers/zones, and run the trigger/zone.
 * @returns >0 if a trigger/zone was found (and executed) where the NPC was standing on.
 * @type number
 * note: check also: TryExecuteTriggersNZones()
 */
function EntriggerEnzone(NPC){
	var map_x = GetPersonX(NPC);
	var map_y = GetPersonY(NPC);
	var layer = GetPersonLayer(NPC);
	var is = 0;
	if(IsTriggerAt(map_x, map_y, layer)){
		ExecuteTrigger(map_x, map_y, layer);
		++is;
	}
	if(AreZonesAt(map_x, map_y, layer)){
		ExecuteZones(map_x, map_y, layer);
		++is;
	}
	return is;
}

//----------------------------------------------------------------------------//

/**
 * Tell us if a certain person is standing on a certain tile
 * @param {string} NPC The person you want to test
 * @param {integer} tile_x X-axis Map coordinate in tiles
 * @param {integer} tile_y Y-axis Map coordinate in tiles
 * @param {integer} layer Layer on which to check for triggers and zones.
 * @param {integer} radius The radius +1 in pixels of the spriteset. 9 by default for a 16x16 spritebase. use 17 to check 1 tile around NPC
 * @returns true if the person is standing on that particular tile, false if not.
 * @type boolean
 * note: If you need to check only 1 tile, do this: if(GetPersonTX(NPC)==tile_x && GetPersonTY(NPC)==tile_y) {...}
 */
function PersonOnTile(NPC,tile_x,tile_y,layer,radius) {
	var abs=Math.abs;
	if(GetPersonLayer(NPC)!=layer)
		return false;
	radius=radius||9;
	if(	(abs(GetPersonX(NPC)-LithoniteEngine.prototype.TileToMapX(tile_x))<radius) &&
		(abs(GetPersonY(NPC)-LithoniteEngine.prototype.TileToMapY(tile_y))<radius) )
		return true;
	return false;
}

//----------------------------------------------------------------------------//

/**
 * Set to true if you have to walk over the tile to 'uncover' the button first before being able to press it. (we have to walk over it again to be able to press it)
 * @param {integer} tile_x X-axis Map coordinate in tiles
 * @param {integer} tile_y Y-axis Map coordinate in tiles
 * @param {integer} layer Layer of the tile
 * @param {integer} tile Tile index of the non-pressed tile
 * @param {integer} tilepressed Tile index of the pressed tile
 * @returns true if it could be uncovered, false if not (because it was already uncovered)
 * @type boolean
 */
function uncoverTile(tile_x,tile_y,layer, tile,tilepressed){
	var currtile=GetTile(tile_x,tile_y,layer);
	if(currtile!=tile && currtile!=tilepressed){
		SetTile(tile_x,tile_y,layer, tile);
		return true;
	}
	return false;
}

/**
 * Toggle a tile between pressed and unpressed states
 * @param {integer} tile_x X-axis Map coordinate in tiles
 * @param {integer} tile_y Y-axis Map coordinate in tiles
 * @param {integer} layer Layer of the tile
 * @param {integer} tile Tile index of the non-pressed tile
 * @param {integer} tilepressed Tile index of the pressed tile
 * @returns 1 if becomes pressed, -1 if it becomes unpressed. 0 if (un)pressed tile were not there (yet).
 * @type integer
 */
function toggleTile(tile_x,tile_y,layer, tile,tilepressed){
	if(GetTile(tile_x,tile_y,layer)==tile){
		SetTile(tile_x,tile_y,layer, tilepressed);
		return 1;
	}else if(GetTile(tile_x,tile_y,layer)==tilepressed){
		SetTile(tile_x,tile_y,layer, tile);
		return -1;
	}
	return 0;
}

/**
 * Combined function for all pressed functions
 * @param {integer} tile_x X-axis Map coordinate in tiles
 * @param {integer} tile_y Y-axis Map coordinate in tiles
 * @param {integer} layer Layer of the tile
 * @param {integer} tile Tile index of the non-pressed tile
 * @param {integer} tilepressed Tile index of the pressed tile
 * @param {integer} unsticky 0 or false if the button will stay that way once pressed. 
 * >0 if the button will revert to its unpressed state after being pressed. 
 * Each 'unsticky' frames we check if we can unstick. Use a number like 30 for half a second (at 60 fps), or 8 for (almost) immediate reversion. 
 * You can also set it to true, for a default of 32. Keep the number of persons on the map low when using this function.
 * @param {Boolean} toggle True if the button unpresses again when we walk over it.
 * @param {Boolean} uncover True if the tile is not 'tile' or 'tilepressed' and we want to set it to 'tile' before being able to press it.
 * @returns something (I'm not able to figure out all those possible values ;) ). I think 1 pressed, -1 unpressed, 2 if toggled, -2 untoggled  and 0 any other thing.
 * @type integer
 */
function ExchangeTile(tile_x,tile_y,layer, tile,tilepressed, unsticky,toggle,uncover){
	if(uncover && uncoverTile(tile_x,tile_y,layer, tile,tilepressed))
		return 0;
	return pressTile(tile_x,tile_y,layer, tile,tilepressed,unsticky) || (toggle && toggleTile(tile_x,tile_y,layer, tile,tilepressed)*2);
}


/**
 * @param {integer} tile_x X-axis Map coordinate in tiles
 * @param {integer} tile_y Y-axis Map coordinate in tiles
 * @param {integer} layer Layer of the tile
 * @param {integer} tile Tile index of the non-pressed tile. If you have tilenames, use GetTileIndex(tilename) to convert it to index.
 * @param {integer} tilepressed Tile index of the pressed tile
 * @param {integer} unsticky 0 or false if the button will stay that way once pressed. 
 * >0 if the button will revert to its unpressed state after being pressed. 
 * Each 'unsticky' frames we check if we can unstick. Use a number like 30 for half a second (at 60 fps), or 8 for (almost) immediate reversion. 
 * You can also set it to true, for a default of 32. Keep the number of persons on the map low when using this function.
 * @param {Boolean} DoAutoPress True if we dont need a person standing on this trigger in order to press it. 
 * If set to false, the button can be pressed only if a person is standing on this tile.
 * Handy for pressing at a distance or during map entry (to reset buttons).
 * @returns 1 if we become pressed, -1 if we become unpressed, 0 if nothing happened (3 possible causes, see function's inline comments)
 * @type integer
 */
function pressTile(tile_x,tile_y,layer, tile,tilepressed,unsticky,DoAutoPress){
	var abs=Math.abs;
	var map_x=LithoniteEngine.prototype.TileToMapX(tile_x);
	var map_y=LithoniteEngine.prototype.TileToMapY(tile_y);

	if(typeof tile=='string') tile=GetTileIndex(tile);
	if(typeof tilepressed=='string') tilepressed=GetTileIndex(tilepressed);
	var currtile=GetTile(tile_x,tile_y,layer);
	if( currtile==tile ) { //current tile is unpressed, pressing 
		var people = GetPersonList();
		if(!DoAutoPress){
		var p=people.length-1;
		do{ 
			if(GetPersonLayer(people[p])!=layer) continue;
			if(	(abs(GetPersonX(people[p])-map_x)<9) &&
				(abs(GetPersonY(people[p])-map_y)<9) )
				DoAutoPress=true;
		}while(p--&&!DoAutoPress);
		};

		if(DoAutoPress){ //Only swap press if someone is standing on it.
			SetTile(tile_x,tile_y,layer, tilepressed );
			if(unsticky){ //Try to autounpress when noone presses this button
				if(typeof unsticky!= "number") unsticky=pressTile.unsticky;
				if(IsTriggerAt(map_x, map_y, layer))
					SetDelayScript(unsticky, "ExecuteTrigger("+map_x+","+map_y+","+layer+");" );
			}
			return 1; //we are pressed
		}
		return 0; //nobody standing on me.... not pressing
	} else if(currtile==tilepressed){
		if(unsticky){ // Tile is currently pressed.Try to autounpress when noone presses this button
			var people = GetPersonList();

			var DoAutoUnpress=true;
			var p=people.length-1;
			do{ 
				if(GetPersonLayer(people[p])!=layer) continue;
				if(	(abs(GetPersonX(people[p])-map_x)<9) &&
					(abs(GetPersonY(people[p])-map_y)<9) )
					DoAutoUnpress=false;
			}while(p--&&DoAutoUnpress)

			if(DoAutoUnpress) {
				SetTile(tile_x,tile_y,layer, tile);
				return -1; //unpressed
			} else {
				if(typeof unsticky!= "number")
					unsticky=pressTile.unsticky;
				if(IsTriggerAt(map_x, map_y, layer))
					SetDelayScript(unsticky, "ExecuteTrigger("+map_x+","+map_y+","+layer+");");
				return 0; //someone standing on me.... will try later...
			}
		}
		return 0; //already pressed, no action required
	}
	return 0; //Tile not one of pressed/unpressed pair.
}

/**
 * The frames it takes a button to unpress itself after being walked on. The default is 32, but you can 
 *
 */
pressTile.unsticky=32;


//----------------------------------------------------------------------------//

/**
 * Sets tile 'tilethen' if 'tileif' is found at the given tile coordinates
 * @param {integer} tile_x X-axis Map coordinate in tiles
 * @param {integer} tile_y Y-axis Map coordinate in tiles
 * @param {integer} layer Layer of the tile
 * @param {integer} tileif Tile index of the tile we expect to be at those tile coordinates
 * @param {integer} tilethen Tile index of the tile we will set it to if 'tileif' is found.
 * @param {integer} delaynumframes Frames we will delay setting the new tile.
 * @returns true if we were able to set the tile 'tilethen', false if not
 * @type boolean
 */
function SetTileIf(tile_x,tile_y,layer, tileif,tilethen,delaynumframes) {
	if( GetTile(tile_x,tile_y,layer)==tileif ) {
		if(delaynumframes)
			SetDelayScript(delaynumframes, "SetTile("+tile_x+","+tile_y+","+layer+","+tilethen+");" );
		else
			SetTile(tile_x,tile_y,layer, tilethen);
		return true;
	}
	return false;
}

/**
 * Same as SetTileIf() but instead of tile indexes, you may give tilenames
 * @param {integer} tile_x X-axis Map coordinate in tiles
 * @param {integer} tile_y Y-axis Map coordinate in tiles
 * @param {integer} layer Layer of the tile
 * @param {string} tileifname Tile name of the tile we expect to be at those tile coordinates
 * @param {string/integer} tilethenname Tile name, index or arithmeric of the tile we will set it to if 'tileif' is found.
 * @param {integer} delaynumframes Frames we will delay setting the new tile.
 * @returns true if we were able to set the tile 'tilethen', false if not
 * @type boolean
 * Example: SetTileIfname(10,12,0, 'unpressedButton', "+1", 16)
 */
function SetTileIfname(tile_x,tile_y,layer, tileifname,tilethenname,delaynumframes) {
	if( GetTileName(GetTile(tile_x,tile_y,layer)) == tileifname ) {
		var tilethen;
		if(typeof tilethenname=='number')
			tilethen = tilethenname; 
		else{
			if(tilethenname[0] == '+' || tilethenname[0] == '-')
				tilethen = GetTile(tile_x,tile_y,layer) + eval(tilethenname);
			else
				tilethen = GetTileIndex(tilethenname);
			if(tilethen>GetNumTiles() || tilethen<0) return false; 
		}
		if(delaynumframes)
			SetDelayScript(delaynumframes, "SetTile("+tile_x+","+tile_y+","+layer+","+tilethen+");" );
		else
			SetTile(tile_x,tile_y,layer, tilethen);
		return true;
	}
	return false;
}

/**
 * returns the index of the tile 'name'
 */
function GetTileIndex(name){
	var tile = GetNumTiles();
	while ( tile > 0 && GetTileName(tile) != name) { --tile; };
	if(GetTileName(tile) == name ) return tile;
	return -1;
}

//----------------------------------------------------------------------------//

/**
 * Offsets a person by tiles, if its not obstructed there (can be changed with parameter ign). Extends lithonite.
 * @param {number} tx X-axis offset in tiles
 * @param {number} ty Y-axis offset in tiles
 * @param {string} person A name of a person, defaults to the current Input Person.
 * @param {Boolean} ign Ignore obstructions (defaults to false)
 * @returns 1 if the person has been repositioned, 0 if not
 * @type integer
 */
LithoniteEngine.prototype.reposTile = function(tx, ty, person, ign) {
	return this.repos(this.TileToMapX(tx),this.TileToMapY(ty),person,ign);
}

/**
 * Sets a person on a tile, if its not obstructed there (can be changed with parameter ign). person will be centered on tile. Extends lithonite.
 * @param {number} tx X-axis tile position
 * @param {number} ty Y-axis tile position
 * @param {string} person A name of a person, defaults to the current Input Person.
 * @param {Boolean} ign Ignore obstructions (defaults to false)
 * @param {number} dx Optional X-axis Offset in pixels, defaults to zero
 * @param {number} dy Optional Y-axis Offset in pixels, defaults to zero
 * @param {integer} layer Layer to move the person to. Leave empty to not change the layer.
 * @returns  1 if the person has been repositioned, 0 if not
 * @type integer
 */
LithoniteEngine.prototype.setposTile = function(tx, ty, person, ign, dx, dy, layer) {
	return this.setpos(this.TileToMapX(tx)+(dx||0),this.TileToMapY(ty)+(dy||0),person||this.GIP,ign,layer);
}

/**
 * Sets a person on the given coordinates, if its not obstructed there (can be changed with parameter ign). Extends lithonite.
 * @param {number} x X-axis
 * @param {number} y Y-axis
 * @param {string} person A name of a person, defaults to the current Input Person.
 * @param {Boolean} ign Ignore obstructions (defaults to false)
 * @param {integer} layer Layer to move the person to. Leave empty to not change the layer.
 * @returns  1 if the person has been repositioned, 0 if not
 * @type integer
 */
LithoniteEngine.prototype.setpos = function(x, y, person, ign, layer) {
	person=person||this.GIP;
	var oldlayer;
	if (typeof layer == 'number'){
		oldlayer = GetPersonLayer(person);
		SetPersonLayer(person, layer);
	}
	if(!ign&&IsPersonObstructed(person,x,y)){
		if(oldlayer) SetPersonLayer(person, oldlayer);
		return 0;
	}
	SetPersonX(person,x);
	SetPersonY(person,y);
	return 1;
}


//----------------------------------------------------------------------------//

